#include <bits/stdc++.h>

using namespace std;

struct segtree {
    int n;
    vector<int> tree;

    void build(int sz) {
        n = 1;
        while (n < sz) n <<= 1;
        tree.assign(n * 2, 0);
    }

    void set(int i, int val) {
        i += n;
        tree[i] = val;
        while (i) {
            i >>= 1;
            tree[i] = tree[2 * i] + tree[2 * i + 1];
        }
    }

    int get(int l, int r, int x, int lx, int rx) {
        if (rx < l || r < lx) return 0;
        if (l <= lx && rx <= r) return tree[x];
        int a = get(l, r, x * 2, lx, (lx + rx) / 2);
        int b = get(l, r, x * 2 + 1, (lx + rx) / 2 + 1, rx);
        return a + b;
    }

    int get(int l, int r) {
        return get(l, r, 1, 0, n - 1);
    }
};

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    string s;
    cin >> s;
    segtree st;
    st.build(s.size());
    for (int i = 0; i < s.size() - 1; ++i) {
        if (s[i] > s[i + 1]) {
            st.set(i, 1);
        }
    }
    int q;
    cin >> q;
    while (q--) {
        int l, r;
        cin >> l >> r;
        --l, --r;
        cout << st.get(l, r - 1) + 1 << '\n';
    }
    return 0;
}
